
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1310.C - Message 1310 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1310 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1310.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:06   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:54:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:48   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:01:38   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:18   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <stdio.h>
#include <share.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void clear_message_line(void);

extern FILE *stream5;
extern short LoadFrqPar;
extern char  frqparfile[32];

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1310 message from the ZMsgBuf.
//
void Dec1310(tMSGBUF *ZMsgBuf, tMSG1310 *Msg)
{

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1310 message in the ZMsgBuf. 
//
void Bld1310(tMSGBUF *ZMsgBuf, tMSG1310 *Msg)
{         
   tDOUBLE C0, C1, C2, C3;
   tFLOAT  TInf, TRef;
   tDOUBLE S0, U0, U1;
   
   // load frequency parameters from file
   if(LoadFrqPar && ((stream5 = _fsopen(frqparfile, "rt", SH_DENYWR)) != NULL)){
      clear_message_line();
      ShowText("LOADING FREQUENCY STANDARD PARAMETERS FROM FILE ... ", CMDR, CMDC);
      LoadFrqPar = 0;
   
      fscanf(stream5,"FREQUENCY STANDARD PARAMETERS ");
      fscanf(stream5,"FILENAME       : %*s ");   // ignore filename
      fscanf(stream5,"SET TIME       : %*lu ");  // ignore set time
      fscanf(stream5,"SEQ NUMBER     : %d "  , &Msg->SequenceNumber);
      fscanf(stream5,"FREQ STD ISSUE : %u "  , &Msg->FSIssue);
      fscanf(stream5,"C0             : %lg " , &C0);
      fscanf(stream5,"C1             : %lg " , &C1);
      fscanf(stream5,"C2             : %lg " , &C2);
      fscanf(stream5,"C3             : %lg " , &C3);
      fscanf(stream5,"TINF           : %f "  , &TInf);
      fscanf(stream5,"D0             : %lg " , &Msg->Dynamics.D0);
      fscanf(stream5,"D1             : %lg " , &Msg->Dynamics.D1);
      fscanf(stream5,"TREF           : %f "  , &TRef);
      fscanf(stream5,"T0             : %u "  , &Msg->Calibration.T0);
      fscanf(stream5,"S0             : %lg " , &S0);
      fscanf(stream5,"U0             : %lg " , &U0);
      fscanf(stream5,"U1             : %lg " , &U1);

      Msg->Characteristics.C0   = (tSHORT) (C0   * TWOP29);
      Msg->Characteristics.C1   = (tSHORT) (C1   * TWOP35);
      Msg->Characteristics.C2   = (tSHORT) (C2   * TWOP41);
      Msg->Characteristics.C3   = (tSHORT) (C3   * TWOP47);
      Msg->Characteristics.TInf = (tSHORT) (TInf *    100);
      Msg->Calibration.TRef     = (tSHORT) (TRef *    100);
      Msg->Calibration.S0       = (tSHORT) (S0   * TWOP18);
      Msg->Uncertainty.U0       = (tSHORT) (U0   * TWOP29);
      Msg->Uncertainty.U1       = (tSHORT) (U1   * TWOP35);
   
      fclose(stream5);
      ShowText("DONE", CMDR, CMDC+52);
   }
   else{
      LoadFrqPar = -1;
   }
   
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                    , ZMsgBuf, 1);  // message preamble
   PutShort  (1310                      , ZMsgBuf, 2);  // message number
   PutShort  (14                        , ZMsgBuf, 3);  // message length 
   PutShort  (ANREQ                     , ZMsgBuf, 4);  // message ack/nack request
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1310 message from the ZMsgBuf.
//
void Show1310(tMSG1310 *Msg)
{      
   // tbd
}                                                 
                                      
                                           
